EvaluateScript("Overworld/VMs.js")
EvaluateScript("Overworld/WildPokemon.js")

const old_ChangeMap=ChangeMap;
const old_MapEngine=MapEngine;

var ChangeMap = function(map){
	BeforeChangeMap()
	old_ChangeMap(map);
	OnChangeMap();
}

var MapEngine = function(map,fps){
	BeforeChangeMap()
	CreatePerson("asdf","Border.rss",true)
	SetPersonScript("asdf",SCRIPT_COMMAND_GENERATOR,"OnChangeMap();DestroyPerson(GetCurrentPerson())")
	old_MapEngine(map,fps);
}
function BeforeChangeMap(){
	Map_Header={}
	//BETA
  WildePokemonGras = new Array()
	MinLevelGras = new Array()
	MaxLevelGras = new Array()
}
function OnChangeMap(){
	player.vm={strength: false};
	if(!IsPersonExist("spieler")){
		CreatePerson("spieler","Ash.rss",true)
		SetPersonScript("spieler",SCRIPT_COMMAND_GENERATOR,"spieler();")
		SetPersonScript("spieler",SCRIPT_ON_CREATE,"cstart();");CallPersonScript("spieler",SCRIPT_ON_CREATE)
	}
	ActualizeDaytime();
	PersonsInGrass();
	ActualizeTilepos()
	
	ArrowDoorScript.x=-1// no arrow-blitting^^
	if(Map_Header.name==undefined||Map_Header.name=="") status.windowstat=undefined
};

function ActualizeDaytime(){
	if(GetLayerIndex("Night")!=-1){
		if(getDaytime()!="Night") SetLayerVisible(GetLayerIndex("Night"),false)
		else SetLayerVisible(GetLayerIndex("Night"),true)
	}
	var l=GetPersonList()
	for(var t=0;t<l.length;++t)
		if(GetPersonValue(l[t],"Tr")){
			if(getDaytime()=="Night"){
				if(GetPersonDirection(l[t]) == "open_day") SetPersonDirection(l[t],"open_night")
				if(GetPersonDirection(l[t]) == "close_day") SetPersonDirection(l[t],"close_night")
			}else{
				if(GetPersonDirection(l[t]) == "open_night") SetPersonDirection(l[t],"open_day")
				if(GetPersonDirection(l[t]) == "close_night") SetPersonDirection(l[t],"close_day")
			}
		}
		
	//if([true,false,false,false,false,false,false,false,false].pick()) Daytime=["Night","Day"].pick()
}

function DaytimeFadings(){
	var time=date.getHours()+date.getMinutes()/60+date.getSeconds()/3600+date.getMilliseconds()/3600000
		var c1=CreateColor(0,0,0,0)
		var c2=CreateColor(0,0,0,0)
		var w=0
	if(time>=7 && time<=8){
		c1=CreateColor(0,0,0,0)
		c2=CreateColor(255,252,185,54)
		w=(time-7)
	}else if(time>8 && time<=9){
		c1=BlendColors(CreateColor(255,252,185,54),CreateColor(0,0,0,176))
		c1.alpha=150
		c2=CreateColor(255,252,185,54)
		w=(time-8)
	}else if(time>9 && time<=10){
		c1=CreateColor(255,252,185,54)
		c2=CreateColor(0,0,0,0)
		w=(time-9)
	}else if(time>=18.5 && time<=19.5){
		c1=CreateColor(0,0,0,0)
		c2=CreateColor(255,70,60,100)
		w=(time-18.5)
	}else if(time>19.5 && time<=20){
		c1=CreateColor(255,70,60,100)
		c2=BlendColors(CreateColor(0,0,0,176),CreateColor(17,22,225,176))
		w=(time-19.5)*2
	}else if(time>20 && time<=21){
		c1=CreateColor(17,22,225,50)
		c2=CreateColor(0,0,0,0)
		w=(time-20)
	}else if(time>21 && time<=24){
		c1=CreateColor(0,0,0,0)
		c2=CreateColor(39,31,88,04)
		w=(time-21)/3
	}else if(time>0 && time<=3){
		c1=CreateColor(39,31,88,04)
		c2=CreateColor(39,31,88,04)
		w=1
	}else if(time>3 && time<=4){
		c1=CreateColor(39,31,88,04)
		c2=CreateColor(0,0,0,0)
		w=(time-3)
	}
		
	var color=BlendColorsWeighted(c1,c2,100-w*100,w*100)
	ApplyColorMask(color)
}

function Test(){
	var start=0
	var end=24
	for(var t=0;t<(end-start)*60;++t){
		SetDelayScript(t,"date.setMinutes("+t%60+")")
		SetDelayScript(t,"date.setHours("+(start+t/60)+")")
	}
}

const old_SetRenderScript=SetRenderScript;
SetRenderScript = function(script){
	old_SetRenderScript(script+"; RenderScript()")
}

SetRenderScript("")

function RenderScript(){
	RenderDoorArrow() // Pfeil beim verlassen von Gebuden etc.
	if(Map_Header.type!="inside" && Map_Header!="cave"&&Map_Header.type!=undefined){
		DaytimeFadings()
	}
	//Ortsschild
	if(status.windowstat!=undefined) ZeigeOrtsschild(status.windowstat.name, status.windowstat.style, status.windowstat.font)
}

const old_SetUpdateScript=SetUpdateScript;
SetUpdateScript = function(script){
	old_SetUpdateScript(script+"; UpdateScript()")
}

SetUpdateScript("")

function UpdateScript(){
	date=new Date;
	UpdateMovQueue()
	ActualizeTilepos()
	ActualizeDaytime()
	//WalkingIntoWall dekrementieren, BETA, sowas bekommt noch eine eigene Funktion
	if(status.walkingIntoWall) status.walkingIntoWall--;
}

function PersonsInGrass(){
	var l=GetPersonList()
	var x
	var y
	var la=GetStartPoint().l
	for(var t=0;t<l.length;++t){
		x=(GetPersonX(l[t])-7)/16
		y=(GetPersonY(l[t])-7)/16
		if(GetTileName(GetTile(x,y,la))=="gras"){
			unanimatedgras(x,y)
		}
	}
}

function unanimatedgras(x,y){
	var name=GetFreePersonName("gras")
	CreatePerson(name,"Verschiedenes/Gras.rss",true)
	IgnorePerson(name)
	SetPersonX(name,x*16+7)
	SetPersonY(name,y*16+7)
	SetPersonFrame(name,3)
	SetPersonScript(name,SCRIPT_COMMAND_GENERATOR,"grasc()")
}

function SetPersonTile(person,tile_index){
	var tile=GetTileImage(tile_index)
	var ss=GetPersonSpriteset(person)
	ss.images[0]=tile
	SetPersonSpriteset(person,ss)
}

function PersonTile(tile_index){
	SetPersonTile(GetCurrentPerson(),tile_index)
}

function getDaytime(){
	var time=date.getHours()+date.getMinutes()/60+date.getSeconds()/3600+date.getMilliseconds()/3600000
	if(time>20||time<8) return "Night"
	return "Day"
}
	/*var Daytime/if(Daytime==undefined) Daytime="Day"
	if(Daytime==undefined) Daytime="Night"
	return Daytime*/

function NightActive(){
	SetPersonScript(GetCurrentPerson(),SCRIPT_COMMAND_GENERATOR,"if(getDaytime())SetPersonVisible(GetCurrentPerson(),false)")
}


function GetStartPoint(){
	var p=".lh|t&%kjlm#nbz]i@@"
	CreatePerson(p,"Border.rss",true)
	var r={x: (GetPersonX(p)-7)/16,y: (GetPersonY(p)-7)/16,l: GetPersonLayer(p)}
	DestroyPerson(p)
	return r
}

function GetLayerIndex(name){
	for(var t=0;t<GetNumLayers();++t) if(GetLayerName(t)==name) return t
	return -1
}

function SetPersonLightTile(tile, person,vx,vy){
	if(person==undefined) var p=GetCurrentPerson();
	else var p=person
	if(vx==undefined) vx=0
	if(vy==undefined) vy=0
	var x=(GetPersonX(p)-7)/16+vx
	var y=(GetPersonY(p)-7)/16+vy
	SetLightTile(x,y,tile)
}

function SetLightTile(x,y,tile){
	var index=GetLayerIndex("Night")
	if(index==-1) index=GetLayerIndex("Darkness")
	if(index==-1) return false
	SetTile(x,y,index,tile)
}

function GetFreePersonName(base){
	var t=0
	while(IsPersonExist(base+(++t))){}
	return base+t
}

function IgnorePerson(p){
	if(p==undefined) p=GetCurrentPerson()
	var l=GetPersonList()
	for(var t=0;t<l.length;++t){
		if(!IsPersonExist(l[t])) continue;
		var a=GetPersonIgnoreList(l[t])
		a.push(p)
		SetPersonIgnoreList(l[t],a)
	}
}

function UnignorePerson(p){
	if(p==undefined) p=GetCurrentPerson()
	var l=GetPersonList()
	for(var t=0;t<l.length;++t){
		if(!IsPersonExist(l[t])) continue;
		var a=GetPersonIgnoreList(l[t])
		for(var i=0;i<a.length;++i) if(a[i]==p) a.remove(i)
		SetPersonIgnoreList(l[t],a)
	}
}

//Falls zerstrt, nicht mehr ignorieren
var old_DestroyPerson=DestroyPerson;
var DestroyPerson = function(name){
	UnignorePerson(name)
	old_DestroyPerson(name)
}


//MAP-HEADER
var Map_Header;
function MapHeader(obj){
	Map_Header=obj
	if(Map_Header.name!=undefined&&Map_Header.name!="") Ortsschild(Map_Header.name)
}
//ORTSCHILD-BETA:
function Ortsschild(name) { 
	var style = "[Overworld]/Ortsschild.png" //oder anderes, wie in den Edis
	var font = "SchwarzH.rfn"
	if(status.windowstat!=undefined){
		status.windowstat.stat=Math.max(status.windowstat.stat,120)
		SetDelayScript(132-status.windowstat.stat,"status.windowstat = {stat:0,name:'"+name+"',style:'"+style+"',font:'"+font+"',pos:-26}")
	}else status.windowstat = {stat:0,name:name,style:style,font:font,pos:-26}
}

function ZeigeOrtsschild(name, style, font){
	if(status.windowstat.stat<12) status.windowstat.pos=status.windowstat.stat*2-24
	else if(status.windowstat.stat<=120) status.windowstat.pos=0
	else if(status.windowstat.stat>120) status.windowstat.pos=(status.windowstat.stat-120)*-2
	status.windowstat.stat++
	LoadImage(style).blit(0,status.windowstat.pos);
	var font=LoadFont(font)
	font.drawText(64-font.getStringWidth(name)/2,status.windowstat.pos+2,name);
	if(status.windowstat.stat==132) status.windowstat=undefined 
}
/////////////////////////////////////////////


//Door-Functions vol. 2
function SideDoorL(x_or_door,y_or_map,map){
	SetPersonVisible(GetCurrentPerson(),false)
	SetPersonValue(GetCurrentPerson(),"STr",true)
	SetPersonScript(GetCurrentPerson(),SCRIPT_COMMAND_GENERATOR,"ArrowDoorScript('l')")
	SetPersonScript(GetCurrentPerson(),SCRIPT_ON_ACTIVATE_TOUCH,"status.justWarped=false;warp("+(typeof(x_or_door)=="number"?x_or_door:("'"+x_or_door+"'"))+","+(typeof(y_or_map)=="number"?y_or_map:("'"+y_or_map+"'"))+","+(typeof(map)=="string"?("'"+map+"'"):map)+")")
}

function ArrowDoorScriptL(){
	return ArrowDoorScript("l")
}

function SideDoorR(x_or_door,y_or_map,map){
	SetPersonVisible(GetCurrentPerson(),false)
	SetPersonValue(GetCurrentPerson(),"STr",true)
	SetPersonScript(GetCurrentPerson(),SCRIPT_COMMAND_GENERATOR,"ArrowDoorScript('r')")
	SetPersonScript(GetCurrentPerson(),SCRIPT_ON_ACTIVATE_TOUCH,"status.justWarped=false;warp("+(typeof(x_or_door)=="number"?x_or_door:("'"+x_or_door+"'"))+","+(typeof(y_or_map)=="number"?y_or_map:("'"+y_or_map+"'"))+","+(typeof(map)=="string"?("'"+map+"'"):map)+")")
}

function BottomDoor(x_or_door,y_or_map,map){
	SetPersonVisible(GetCurrentPerson(),false)
	SetPersonValue(GetCurrentPerson(),"STr",true)
	SetPersonScript(GetCurrentPerson(),SCRIPT_COMMAND_GENERATOR,"ArrowDoorScript('u')")
	SetPersonScript(GetCurrentPerson(),SCRIPT_ON_ACTIVATE_TOUCH,"status.justWarped=false;SetPersonFrame(GetInputPerson(),0);warp("+(typeof(x_or_door)=="number"?x_or_door:("'"+x_or_door+"'"))+","+(typeof(y_or_map)=="number"?y_or_map:("'"+y_or_map+"'"))+","+(typeof(map)=="string"?("'"+map+"'"):map)+")")
}

function BottomDoorMove(dir,x_or_door,y_or_map,map){
	SetPersonVisible(GetCurrentPerson(),false)
	SetPersonValue(GetCurrentPerson(),"STr",true)
	SetPersonScript(GetCurrentPerson(),SCRIPT_COMMAND_GENERATOR,"ArrowDoorScript('u')")
	SetPersonScript(GetCurrentPerson(),SCRIPT_ON_ACTIVATE_TOUCH,"status.justWarped=false;SetPersonFrame(GetInputPerson(),0);warp("+(typeof(x_or_door)=="number"?x_or_door:("'"+x_or_door+"'"))+","+(typeof(y_or_map)=="number"?y_or_map:("'"+y_or_map+"'"))+","+(typeof(map)=="string"?("'"+map+"'"):map)+");Move(GetInputPerson(),'"+dir+"')")
}


function ArrowDoorScript(dir){
	var facing=true
	if(dir=="l" && GetPersonDirection(GetInputPerson())!="west") facing=false;
	if(dir=="r" && GetPersonDirection(GetInputPerson())!="east") facing=false;
	if(dir=="u" && GetPersonDirection(GetInputPerson())!="south") facing=false;
	if(!facing){
		if(ArrowDoorScript.person==GetCurrentPerson()){
			ArrowDoorScript.x=-1
			ArrowDoorScript.y=-1
			ArrowDoorScript.frame=0
			ArrowDoorScript.framec=0
			ArrowDoorScript.person=null
		}
		return
	}else{
		if(!IsCommandQueueEmpty(GetInputPerson())){
			if(Math.abs(GetPersonX(GetInputPerson())-GetPersonX(GetCurrentPerson()))<=16 && Math.abs(GetPersonY(GetInputPerson())-GetPersonY(GetCurrentPerson()))<=16)
			return
		}
	}
	var isthere=false
	if(dir=="l" && GetPersonX(GetInputPerson())<=GetPersonX(GetCurrentPerson())+31 && GetPersonX(GetInputPerson())>GetPersonX(GetCurrentPerson()) && GetPersonY(GetInputPerson())==GetPersonY(GetCurrentPerson()))
	isthere=true;
	else if(dir=="r" && GetPersonX(GetInputPerson())>=GetPersonX(GetCurrentPerson())-31 && GetPersonX(GetInputPerson())<GetPersonX(GetCurrentPerson()) && GetPersonY(GetInputPerson())==GetPersonY(GetCurrentPerson()))
	isthere=true;
	else if(dir=="u" && GetPersonX(GetInputPerson())==GetPersonX(GetCurrentPerson()) && GetPersonY(GetInputPerson())<GetPersonY(GetCurrentPerson()) && GetPersonY(GetInputPerson())>=GetPersonY(GetCurrentPerson())-31)
	isthere=true;
	else{
		if(ArrowDoorScript.person==GetCurrentPerson()){
			ArrowDoorScript.x=-1
			ArrowDoorScript.y=-1
			ArrowDoorScript.frame=0
			ArrowDoorScript.framec=0
			ArrowDoorScript.person=null
		}
	}
	if(isthere){
		ArrowDoorScript.person=GetCurrentPerson()
		ArrowDoorScript.x=GetPersonX(GetCurrentPerson())-7
		ArrowDoorScript.y=GetPersonY(GetCurrentPerson())-7
		ArrowDoorScript.framec++
		if(ArrowDoorScript.framec==32){
			ArrowDoorScript.framec=0;
			ArrowDoorScript.frame=(ArrowDoorScript.frame+1)%2;
		}
		if(dir!=ArrowDoorScript.dir){
			ArrowDoorScript.img1=LoadImage("[Overworld]/DoorArrow1"+dir+".png")
			ArrowDoorScript.img2=LoadImage("[Overworld]/DoorArrow2"+dir+".png")
			ArrowDoorScript.dir=dir
		}
	}
}

ArrowDoorScript.img1=null
ArrowDoorScript.img2=null
ArrowDoorScript.x=-1
ArrowDoorScript.y=-1
ArrowDoorScript.frame=0
ArrowDoorScript.framec=0
ArrowDoorScript.dir=null
ArrowDoorScript.person=null



function RenderDoorArrow(){
	if(ArrowDoorScript.x==-1) return
	var mask=(getDaytime()=="Night"&&GetLayerIndex("Night")!=-1)?CreateColor(176,176,176,255):CreateColor(255,255,255,255)
	if(ArrowDoorScript.frame==0) ArrowDoorScript.img1.blitMask(MapToScreenX(0,ArrowDoorScript.x), MapToScreenY(0,ArrowDoorScript.y),mask)
	if(ArrowDoorScript.frame==1) ArrowDoorScript.img2.blitMask(MapToScreenX(0,ArrowDoorScript.x), MapToScreenY(0,ArrowDoorScript.y),mask)
}






